/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.stone;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.util.FallingBlockManager;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariantFallable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockFarmlandTFC
extends BlockRockVariantFallable {
    public static final int MAX_MOISTURE = 15;
    public static final PropertyInteger MOISTURE = PropertyInteger.func_177719_a((String)"moisture", (int)0, (int)15);
    public static final int[] TINT = new int[]{-1, -526345, -1052689, -1579033, -2105377, -2631721, -3158065, -3684409, -4210753, -4737097, -5263441, -5789785, -6316129, -6842473, -7368817, -7895161};
    private static final AxisAlignedBB FARMLAND_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
    private static final AxisAlignedBB FLIPPED_AABB = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);

    public BlockFarmlandTFC(Rock.Type type, Rock rock) {
        super(type, rock);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(1)));
        this.func_149675_a(true);
        this.func_149713_g(255);
        this.field_149783_u = true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MOISTURE);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FARMLAND_AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int target;
        int current = (Integer)state.func_177229_b((IProperty)MOISTURE);
        int n = target = world.func_175727_C(pos.func_177984_a()) ? 15 : this.getWaterScore((IBlockAccess)world, pos);
        if (current < target) {
            if (current < 15) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(current + 1)), 2);
            }
        } else if (current > target || target == 0) {
            if (current > 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(current - 1)), 2);
            } else if (!this.hasCrops(world, pos)) {
                this.turnToDirt(world, pos);
            }
        }
        super.func_180650_b(world, pos, state, rand);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MOISTURE});
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN && side != EnumFacing.UP;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int getWaterScore(IBlockAccess world, BlockPos pos) {
        int hRange = 7;
        float score = 0.0f;
        for (BlockPos.MutableBlockPos i : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-7, -1, -7), (BlockPos)pos.func_177982_a(7, 2, 7))) {
            BlockPos diff = i.func_177973_b((Vec3i)pos);
            float hDist = MathHelper.func_76129_c((float)(diff.func_177958_n() * diff.func_177958_n() + diff.func_177952_p() * diff.func_177952_p()));
            if (hDist > 7.0f || world.func_180495_p((BlockPos)i).func_185904_a() != Material.field_151586_h) continue;
            score += (7.0f - hDist) / 7.0f;
        }
        return score > 1.0f ? 15 : Math.round(score * 15.0f);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        IBlockState up;
        if (fromPos.func_177956_o() == pos.func_177956_o() + 1 && (up = world.func_180495_p(fromPos)).isSideSolid((IBlockAccess)world, fromPos, EnumFacing.DOWN) && FallingBlockManager.getSpecification(up) == null) {
            this.turnToDirt(world, pos);
        }
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockFarmlandTFC.get(this.rock, Rock.Type.DIRT));
    }

    private void turnToDirt(World world, BlockPos pos) {
        world.func_175656_a(pos, BlockFarmlandTFC.get(this.rock, Rock.Type.DIRT).func_176223_P());
        AxisAlignedBB axisalignedbb = FLIPPED_AABB.func_186670_a(pos);
        for (Entity entity : world.func_72839_b(null, axisalignedbb)) {
            double d0 = Math.min(axisalignedbb.field_72337_e - axisalignedbb.field_72338_b, axisalignedbb.field_72337_e - entity.func_174813_aQ().field_72338_b);
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + d0 + 0.001, entity.field_70161_v);
        }
    }

    private boolean hasCrops(World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block instanceof IPlantable && this.canSustainPlant(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)block);
    }
}

